<?php
session_start();
include 'db.php'; // Database conn file

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = isset($_POST['product_id']) ? (int)$_POST['product_id'] : 0;
    
    if ($product_id > 0) {
        // Retrieve product information from the database
        $query = "SELECT p.Product_id, 
p.Product_name, 
p.Selling_price,
p.Product_image, 
s.Seo_title,
s.Seo_description
FROM product p
LEFT JOIN product_seo s ON p.Product_id = s.Product_id  WHERE p.Product_id = $product_id AND p.Delete_status = 0";
        $result = mysqli_query($conn, $query);

        // Check if query was successful
        if (!$result) {
            echo json_encode(['success' => false, 'message' => 'Error executing query: ' . mysqli_error($conn)]);
            exit;
        }

        $product = mysqli_fetch_assoc($result);

        if ($product) {
            // Retrieve product image information
         
            // Initialize cart if it doesn't exist
            if (!isset($_SESSION['cart'])) {
                $_SESSION['cart'] = [];
            }

            // Check if the product is already in the cart
            if (isset($_SESSION['cart'][$product_id])) {
                $_SESSION['cart'][$product_id]['quantity'] += 1;
            } else {
                // Add new product to the cart with quantity 1
                $_SESSION['cart'][$product_id] = [
                    'id' => $product_id,
                    'productimage' => $product['Product_image'],
                    'seotitle' => $product['Seo_title'],
                    'seodescription' => $product['Seo_description'],
                    'productname' => $product['Product_name'], // Adjust column name if needed
                    'price' => $product['Selling_price'], // Adjust column name if needed
                    'quantity' => 1
                ];
            }

            echo json_encode(['success' => true, 'message' => 'Product added to cart successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Product not found.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid product ID.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}
?>
